use "data beta sector SP500.dta"


local out = "replace"

foreach var in effectivetaxrates profitmargin  netdebtpersales capitalexpenditurepersale retainedearningspersale  rdexpenditurepersale foreign {
	
	if `var' ==  profitmargin  local out = "append" 
	reg beta `var'
	outreg2 using Regression\Table2a.xls, `out' /// 
	label title("Sector characteristics driving the TCJA elasticities") 
	*ctitle("2017") 
	* ///
	*addnote(Newey-West standard error in parentheses, *** p<0.01; ** p<0.05; * p<0.1) nonotes

}



local out = "replace"

foreach var in effectivetaxrates profitmargin netdebtpersales capitalexpenditurepersale tangiblebookvaluepersales foreign {
	
	if `var' ==  profitmargin  local out = "append" 
	reg beta `var' pxtobookratio 
	outreg2 using Regression\Table2b.xls, `out' /// 
	label title("Sector characteristics driving the TCJA elasticities") 
	*ctitle("2017") 
	* ///
	*addnote(Newey-West standard error in parentheses, *** p<0.01; ** p<0.05; * p<0.1) nonotes

}



*Build the residual of H2 expectations on H1 expectations

reg betah2 betah1

predict res, residual
